/* sccsid[] = "@(#) $Id: //bas/46D/src/include/crfcsapp.h#3 $ SAP" */   
//

// SAP RFC C++ Class library.
// Copyright (C) 1996 SAP America, Inc.
// All rights reserved.
                        

////////////////////////////////////////////////////////////////////////////////
//  File crfcsapp.h
//
//  Declarations for class CRfcServerApp
//  Declarations for class CRfcPing
//
////////////////////////////////////////////////////////////////////////////////

#ifndef CRFCSAPP__H
#define CRFCSAPP__H

#include "crfcglob.h"
#include "crfcconn.h"
#include "crfcserv.h"

// Constant strings used in this class
#ifdef _WIN32
#include <windows.h>
#include <tchar.h>
                    
#define   CRFCSAPP_CONSTRUCTOR  \
            _T("CRfcServerApp::CRfcServerApp (CRfcConnection*) called")
#define   CRFCSAPP_DESTRUCTOR  \
            _T("CRfcServerApp::~CRfcServerApp (void) called")
#define   CRFCSAPP_RUN  \
            _T("CRfcServerApp::Run(void) called")
#define   CRFCSAPP_EXITINSTANCE  \
            _T("CRfcServerApp::ExitInstance(void) called")
#define   CRFCSAPP_ONIDLE  \
            _T("CRfcServerApp::OnIdle called")
#define   CRFCSAPP_INVOKE  \
            _T("CRfcServerApp::Invoke called")
#define   CRFCSAPP_DISPATCH  \
            _T("CRfcServerApp::Dispatch called")
#define   CRFCSAPP_DISPATCHDOCU  \
            _T("CRfcServerApp::DispatchDocu called")

#define   FUNCTION_NOT_FOUND   _T("RFC function does not exist!")
#define   ALLOW_ONE_INSTANCE   _T("Only one instance can be created!")
#define   NO_DOCU              _T("Documentation not available!")
#define   NL                   _T("\n")
#define   CRFCSAPP_INVOKE_CLONE_NOT_DEFINED \
	      _T("The clone function CRfcServerApp::clone() has not been implemented in the derived class of CRfcServerFunc")
#define   CRFCSAPP_RUN_THREADS_ERROR \
 	      _T("In CRfcServerApp::Run,  some threads failed in this RFC server.")
#define   CRFCSAPP_INVOKE_CLONE_ERROR \
	      _T("In CRfcServerApp::Invoke, the clone function CRfcServerApp::clone() has not been implemented in the derived class of CRfcServerFunc.")
#define   CRFCSAPP_THREAD_NO_CONNECTION \
 	      _T("In CRfcServerApp::StartThreadServer, no RFC connection established yet for the application!")
#define   CRFCSAPP_STARTTHREADSERVER \
           _T("CRfcServerApp::StartThreadServer called")
#define   CRFCSAPP_RFCPINGSERVER \
	       _T("CRfcServerApp:::RFCPINGServer(void) called")

#else

#define   CRFCSAPP_CONSTRUCTOR  \
            "CRfcServerApp::CRfcServerApp (CRfcConnection*) called"
#define   CRFCSAPP_DESTRUCTOR  \
            "CRfcServerApp::~CRfcServerApp (void) called"
#define   CRFCSAPP_RUN  \
            "CRfcServerApp::Run(void) called"
#define   CRFCSAPP_EXITINSTANCE  \
            "CRfcServerApp::ExitInstance(void) called"
#define   CRFCSAPP_ONIDLE  \
            "CRfcServerApp::OnIdle called"
#define   CRFCSAPP_INVOKE  \
            "CRfcServerApp::Invoke called"
#define   CRFCSAPP_DISPATCH  \
            "CRfcServerApp::Dispatch called"
#define   CRFCSAPP_DISPATCHDOCU  \
            "CRfcServerApp::DispatchDocu called"

#define   FUNCTION_NOT_FOUND   "RFC function does not exist!"
#define   ALLOW_ONE_INSTANCE   "Only one instance can be created!"
#define   NO_DOCU              "Documentation not available!"
#define   NL             "\n"
#define   CRFCSAPP_INVOKE_CLONE_NOT_DEFINED \
	      "The clone function CRfcServerApp::clone() has not been implemented in the derived class of CRfcServerFunc"
#define   CRFCSAPP_RUN_THREADS_ERROR \
 	      "In CRfcServerApp::Run, some threads failed in this RFC server."
#define   CRFCSAPP_INVOKE_CLONE_ERROR \
 	      "In CRfcServerApp::Invoke, the clone function CRfcServerApp::clone() has not been implemented in the derived class of CRfcServerFunc."
#define   CRFCSAPP_THREAD_NO_CONNECTION \
 	      "In CRfcServerApp::StartThreadServer, no RFC connection established yet for the application!"
#define   CRFCSAPP_STARTTHREADSERVER \
           "CRfcServerApp::StartThreadServer called"
#define   CRFCSAPP_RFCPINGSERVER \
	       "CRfcServerApp:::RFCPINGServer(void) called"

#endif


////////////////////////////////////////////////////////////////////////////////
// CRfcServerApp class declaration 

class CRfcServerApp
{

public:
	//Only one instance of this class can be created
	//May throw exception, exception type char*, if attempt to
    //create more than one server app object
    CRfcServerApp (CRfcConnection* pConnection = NULL) ;
    virtual ~CRfcServerApp (void);

// operations  											  //  If nChildThreads=0, it is equal to RFC_RC Run (void)   
	const CRfcConnection* GetConnection    (void) const { return m_pConnection; }
    void            SetConnection    (CRfcConnection& connection);
    int             GetFunctionCount (void) const  { return m_FunctionList.GetSize (); }
    CRfcServerFunc* GetServerFunction(int nIndex ) const { return m_FunctionList[nIndex]; }
    CRfcServerFunc* GetServerFunction(RFC_FUNCTIONNAME functionName) const { return m_FunctionList[functionName]; }
    
    // These are to be used if you implemented your server functions
    // in pure C functions.
    RFC_RC       InstallFunction (RFC_FUNCTIONNAME functionName, 
                                        //Null terminated name
                                  RFC_ONCALL fp, 
                                  char* Description) { return ::RfcInstallFunction(functionName, fp, Description); }

	RFC_RC UnInstallFunction (RFC_FUNCTIONNAME functionName) { return ::RfcUninstallFunction(functionName); }

    RFC_RC       Dispatch        (void);
    RFC_RC       GetName         (RFC_FUNCTIONNAME functionName) { return ::RfcGetName (m_pConnection->GetHandle(), functionName); }
	RFC_HANDLE GetConnectionRfcHandle(void) const { if (m_pConnection) return m_pConnection->GetHandle (); else	return RFC_HANDLE_NULL; }
                                    
    // These are to be used if you derived from the CRfcServerFunc class
    // and put your server function code in the Process() member function.
    void         AddServerFunction    (CRfcServerFunc& serverFunc); 
    void         RemoveServerFunction (int nIndex );
    void         RemoveServerFunction (RFC_FUNCTIONNAME functionName );

    //Main loop of the server app, which takes care of listening to
    //incoming requests, dispatching to appropriate server function
    //objects, and calling ReceiveData/Process/ReturnCall on them.
    //May throw CRFC_ERROR_INFO exception when getting RFC name and data, 
    //and sending RFC data. 
#if defined(CRFCwithTHREADS)
	RFC_RC       Run    (int nChildThreads=0);
#else
	RFC_RC       Run    (void);
#endif
	         //  Now we can pass a reference of a RFC Handle to the function
			//   But we do not need to pass the handle into the function.
			//   It is only an option.  All old applications that calling
			//  Run(void) does not need to change.

    //Stop the ServerApp. The default implementation closes the 
    //RFC connection so that it will result stopping the run loop. 
    //Users can provide their own means of ServerApp stop implementation.
    virtual void ExitInstance  (void);

    // Implement this function if you want to do something when the
    // server is idle or during listening for response. 
    virtual void OnIdle () ;

protected:
// attributes
    // Used to make sure only one
    // Instance of CRfcServerApp is created
    static unsigned          m_nAppCreated   ;
    //Keep the only instance, internal use only
    static CRfcServerApp*    m_pInstance;


    //RFC lib desiganated user RFC dispatcher function name
    static RFC_FUNCTIONNAME  m_strDispatcher; 
    
    //Lookup called function name and Invoke process in the ServerFunc  
#ifdef SAPonOS390
    static RFC_RC __cdecl DLL_CALL_BACK_FUNCTION Dispatch (RFC_HANDLE rfc_handle);
#else
    static RFC_RC DLL_CALL_BACK_FUNCTION Dispatch (RFC_HANDLE rfc_handle);
#endif
    
    //Provide description for Invoke
    static char* DispatchDocu (void);

    CRfcConnection*            m_pConnection;
    CRfcList<CRfcServerFunc>   m_FunctionList;

    CRFC_ERROR_INFO             m_RfcErrorInfo;  // Used for last error

    //disallow copying and assignment between CRfcServerApp objects
    CRfcServerApp (const CRfcServerApp& sourceApp);
    CRfcServerApp& operator=( const CRfcServerApp& sourceApp );

    //Invoke the ServerFunc's process
    void Invoke(RFC_HANDLE RfcHandle, RFC_FUNCTIONNAME FunctionName) ; 
private:
	static BOOL IsMultiThreading;
#if defined(CRFCwithTHREADS)  
private:  //  All these variables and methods can only be accessed internally 
	int StartThreadServer(int nChildThreads=0);  
						//  For starting a thread server												  
						//  If nChildThreads=0, it is equal to RFC_RC Run (void)
	static int RFC_RegisterThread(void *lpParms); 
	static void rfc_error(char *operation, int thread_id);
	static void function_abort(RFC_HANDLE rfc_handle, char *atext);
	static int SNC_check(RFC_HANDLE rfc_handle);
	static void PRINT_RFC_CALL(int thread_id, char * text);
#endif
};    

//////////////////////////////////////////////////////////////////
//  Declarations for class CRfcPing
//  This class is for the RFC server to reply a ping request
//////////////////////////////////////////////////////////////////

class CRfcPing : public CRfcServerFunc
{
public:
	CRfcPing (CSTR strFuncName="RFCPING");
	~CRfcPing ();
	void Process (void);
	char * GetDescription (void);
};

#endif          //CRFCSAPP__H
